<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>


<!-- Parameters for determining the movie cover art file name and average rating.
	These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="addMyListParam" select="'default'"/>

<!-- 	Template for root document element.
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<xsl:template match="MOVIE">
<!--Start  blue border table w=597 --> 
	<table width="597" border="0" cellspacing="0" cellpadding="2">
	<tr id="ltblueback" valign="top"> 
		<td id="ltblueback">
		<!--Start  white content table w=593 --> 
			<table id="wtback" border="0" cellspacing="0" cellpadding="0" width="593" >
			<tr> 
				<td id="wtback" width="206" height="323" valign="top"> 
					<table width="89" border="0" cellspacing="0" cellpadding="0">
					<tr> 
						<td id="greenback">
							<span id="smalltext">&#160;add to my list 
								<input type="checkbox">
									<xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="PRODUCT_ID"/></xsl:attribute>
								</input>
							</span>
						</td>
					</tr>
					</table>
					<xsl:call-template name="movieArt">
					</xsl:call-template>
					<br/>
				</td>
				<td id="wtback" width="387" valign="top">
					<span id="movieTitle"><b><xsl:call-template name="movieLongName"/><br/><br/></b></span>
					<b><span id="movieHeading">Genre:</span> </b><span id="normaltext"><xsl:value-of select="GENRES/GENRES_ITEM[1]"/></span>
					<b><br/><span id="movieHeading">Producer:</span> </b>&#160;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieProducer"/></span>
					<b><br/><span id="movieHeading">Director:</span> </b>&#160;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieDirector"/></span>
					<b><br/><span id="movieHeading">Starring:</span> </b>&#160;<span id="normaltext"><xsl:apply-templates select="//CONTRIBUTORS" mode="movieStar"/></span>


					<!--Start ratings  table w=190-->
					<table width="190" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top"> 
						<td width="63" height="50"><img src="images/seenitrateit.gif" width="62" height="51" /><br/></td>
						<td width="127" valign="top" align="left" height="50"> 
							<!--Start iguys table w=126-->
							<table width="126" border="0" cellspacing="0" cellpadding="0">
							<tr valign="top" align="left"> 
								<!-- 	title 	-->
								<td height="13" width="126"><img name="title0" src="images/spacer.gif" width="126" height="13" border="0" alt="" /></td>
							</tr>
							<tr valign="top" align="left"> 
								<!--	iguys	-->
								<td height="21" width="126"> 
									  <img name="iguy0" src="images/iguy_null.gif" width="95" height="21" border="0" usemap="#predicted0" alt="iiiiii" />
								</td>
							</tr>
								<!-- 	predicted rating line 	-->
							<tr align="left" valign="top">  
								<td height="6" width="126"><img name="line0" src="images/spacer.gif" vspace="0" width="95" height="6" border="0" alt=""/></td>
							</tr>
							</table>
						<!--End iguys table w=126-->
						</td>
						<!-- Clear rating button -->
						<td align="right">
							&#160;&#160;<a href="javascript:clearRatings();" id="clearAllLink">clear</a>
						</td>
					</tr>
	<!--				<tr valign="top"> 
						<td colspan="2" height="9"><span id="smalltext"><b>Average Rating : 5.2</b></span></td>
					</tr>-->
					<tr valign="top"> 
						<td colspan="2" height="29">
							<span id="normaltext"><b>Haven't seen it? Want to?<br/></b></span>
						&#160;&#160;<img name="button0" src="images/want_null.gif" width="153" height="15" border="0" alt="want" usemap="#radiobutton0" />
						</td>
					</tr>
					</table>
				<!--End ratings  table w=190--><br/>
					<span id="normaltext"><b>Synopsis: </b><xsl:apply-templates select="//NOTES" mode="movieDescription"/><br/>
					<p/>
					<a href="javascript:goBack()"><img src="images/buttons_sm_previous.gif" width="124" height="30" alt="Previous Page" /></a><input type="image" src="images/buttons_sm_submit.gif" width="124" height="30" alt="submit" />&#160;&#160;<br/>
					<br/>
					<br/>
					</span>
				</td>
			</tr>
			</table>
			<!--End  white content table w=593 -->
		</td>
	</tr>
	</table>
	<!--End  blue border table w=597 -->
</xsl:template>

</xsl:stylesheet>
